<?php
/**
 * WP Events Registration Form
 *
 * This file mainly consists of HTML
*/
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Displays Registration Form on single page
 *
 * @since 1.0.0
 */
if( !function_exists( 'wpe_registration_form' ) ) {
    function wpe_registration_form() {

        /**
         * Fires Before Registration Form
         *
         * @since 1.0.0
         * @action wpe_before_registration_form
        */
        do_action('wp_event_before_registration_form');

	    $form_options               = get_option( 'wpe_forms_settings' );
	    $captcha_options            = get_option( 'wpe_reCAPTCHA_settings' );
	    $labels                     = isset( $form_options['form_labels'] );
	    $form_button                = isset( $form_options['registration_form_button'] ) ? $form_options['registration_form_button'] : __( 'Submit', 'simple-wp-events' );
        $addrees1                   = isset( $form_options['form_address1'] );
        $addrees2                   = isset( $form_options['form_address2'] );
        $city                       = isset( $form_options['form_city'] );
        $state                      = isset( $form_options['form_state'] );
        $zip                        = isset( $form_options['form_zip'] );
        $fax                        = isset( $form_options['form_fax'] );
        $businessName               = isset( $form_options['form_businessName'] );
        $hearAbout                  = isset( $form_options['form_hear_about'] );
        $req_addrees1               = isset( $form_options['req_form_address1'] );
        $req_addrees2               = isset( $form_options['req_form_address2'] );
        $req_city                   = isset( $form_options['req_form_city'] );
        $req_state                  = isset( $form_options['req_form_state'] );
        $req_zip                    = isset( $form_options['req_form_zip'] );
        $req_fax                    = isset( $form_options['req_form_fax'] );
        $req_phone                  = isset( $form_options['req_form_phone'] );
        $req_email                  = isset( $form_options['req_form_email'] );
        $req_businessName           = isset( $form_options['req_form_businessName'] );
        $form_textin_permission     = isset( $form_options['reg_form_texting_permission'] ) ? $form_options['reg_form_texting_permission'] : 'I agree to receive texts at the number provided from [wpe_firm_name]. Frequency may vary and include information on appointments, events, and other marketing messages. Message/data rates may apply. To opt-out, text STOP at any time.';
        $hide_texting_permission    = isset( $form_options['reg_enable_texting_permission'] );
        ?>
        <div class="wpe-main-form-holder">
            <div class="wpe-register-form-container">
                    <?php
                        // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
                       $safe_request_uri = esc_url( wp_unslash( isset( $_SERVER['REQUEST_URI'] ) ? $_SERVER['REQUEST_URI'] : '' ) );
                    ?>
                    <form method="post" action="<?php echo esc_url( $safe_request_uri); ?>" class="wpe-register-form" id="wpe-register-form" novalidate autocomplete="off">
                    <div class="wpe-col-full wpe-field">
                        <div class="wpe-above-error-field" id="wpe-error-div"><span class="wpe-error-exclamation">! </span><?php esc_html_e( 'There was some problem with your submission. Please review the fields below', 'simple-wp-events' ); ?></div>
                    </div>
                    <div class="wpe-col-2 wpe-field">
                        <div class="wpe-form-control wpe-field-container wpe-left-half">
                        <?php if( $labels) { echo'<label for="wpe_first_name">' . esc_html__( 'First Name *', 'simple-wp-events' ) . '</label>';}?>
                        <input class="wpe-field" type="text" name="wpe_first_name" id="wpe_first_name" <?php if( !$labels ) {?>placeholder="<?php esc_html_e( 'First Name *', 'simple-wp-events' ); ?>" <?php } ?> required>
                        <small><?php esc_html_e( 'This field is required.', 'simple-wp-events' ); ?></small>
                   </div>
                   <div class="wpe-form-control wpe-field-container wpe-right-half">
                        <?php if( $labels) { echo'<label for="wpe_last_name">' . esc_html__( 'Last Name *', 'simple-wp-events' ) . '</label>';}?>
                        <input class="wpe-field" type="text" name="wpe_last_name" id="wpe_last_name" <?php if( !$labels ) {?>placeholder="<?php esc_html_e( 'Last Name *', 'simple-wp-events' ); ?>" <?php } ?>required>
                        <small><?php esc_html_e( 'This field is required.', 'simple-wp-events' ); ?></small>
                   </div>
                </div>
                <div class="wpe-col-2 wpe-field">
                <?php if ( ! $addrees1 ) { 
                    $star = $req_addrees1 ? ' *' : '';
                    ?>
                    <div class="wpe-form-control wpe-field-container wpe-left-half">
                        <?php if( $labels) { echo'<label for="wpe_address">' . esc_html__( 'Address', 'simple-wp-events' ) . esc_html($star) .'</label>';}?>
                        <input class="wpe-field" type="text" name="wpe_address" id="wpe_address" <?php if( !$labels ) {?>placeholder="<?php esc_html_e( 'Address', 'simple-wp-events' ); echo esc_html($star); ?>" <?php } echo $req_addrees1 ? 'required' : ''; ?>>
                        <small><?php esc_html_e( 'This field is required.', 'simple-wp-events' ); ?></small>
                    </div>
                    <?php }   if ( ! $addrees2 ) {
                    $star = $req_addrees2 ? ' *' : '';
                    ?>
                    <div class="wpe-form-control wpe-field-container wpe-right-half">
                        <?php if( $labels) { echo'<label for="wpe_address_2">' . esc_html__( 'Address 2', 'simple-wp-events' ) . esc_html($star) . '</label>';}?>
                        <input class="wpe-field" type="text" name="wpe_address_2" id="wpe_address_2" <?php if( !$labels ) {?>placeholder="<?php esc_html_e( 'Address 2', 'simple-wp-events' ); echo esc_html($star); ?>" <?php } echo $req_addrees2 ? 'required' : ''; ?>>
                        <small><?php esc_html_e( 'This field is required.', 'simple-wp-events' ); ?></small>
                    </div>
                    <?php  } ?>
                </div>
                <div class="wpe-col-3 wpe-field">
                <?php if ( ! $city ) { 
                    $star = $req_city ? ' *' : '';
                    ?>
                    <div class="wpe-form-control wpe-field-container wpe-left-third">
                        <?php if( $labels) { echo'<label for="wpe_city">' . esc_html__( 'City ', 'simple-wp-events' ) . esc_html($star) . '</label>';}?>
                        <input class="wpe-field" type="text" name="wpe_city" id="wpe_city" <?php if( !$labels ) {?>placeholder="<?php esc_html_e( 'City', 'simple-wp-events' ); echo esc_html($star); ?>" <?php } echo $req_city ? 'required' : ''; ?>>
                        <small><?php esc_html_e( 'This field is required.', 'simple-wp-events' ); ?></small>
                    </div>
                    <?php } if ( ! $state ) {
                    $star = $req_state ? ' *' : '';
                    ?>
                    <div class="wpe-form-control wpe-field-container wpe-middle-third">
                        <?php if( $labels) { echo'<label for="wpe_state">' . esc_html__( 'State ', 'simple-wp-events' ) . esc_html($star) . '</label>';}?>
                        <input class="wpe-field" type="text" name="wpe_state" id="wpe_state" <?php if( !$labels ) {?>placeholder="<?php esc_html_e( 'State', 'simple-wp-events' ); echo esc_html($star); ?>" <?php } echo $req_state ? 'required' : ''; ?>>
                        <small><?php esc_html_e( 'This field is required.', 'simple-wp-events' ); ?></small>
                    </div>
                    <?php } if ( ! $zip ) { 
                    $star = $req_zip ? ' *' : '';
                    ?>
                    <div class="wpe-form-control wpe-field-container wpe-right-third">
                        <?php if( $labels) { echo'<label for="wpe_zip">' . esc_html__( 'Zip ', 'simple-wp-events' ) . esc_html($star) . '</label>';}?>
                        <input class="wpe-field" type="text" name="wpe_zip" id="wpe_zip" <?php if( !$labels ) {?>placeholder="<?php esc_html_e( 'Zip', 'simple-wp-events' ); echo esc_html($star); ?>" <?php } echo $req_zip ? 'required' : ''; ?>>
                        <small><?php esc_html_e( 'This field is required.', 'simple-wp-events' ); ?></small>
                        <span class="wpe-zip-error-class"><?php esc_html_e( 'Please enter correct zip code.', 'simple-wp-events' ); ?></span>
                    </div>
                    <?php }?>
                </div>
                <div class="wpe-col-3 wpe-field">
                    <?php $star = $req_phone ? ' *' : ''; ?>
                    <div class="wpe-form-control wpe-field-container wpe-left-third">
                        <?php if ( $labels) { echo'<label for="wpe_phone">' . esc_html__( 'Phone/Cell Phone', 'simple-wp-events' ) . esc_html($star) . '</label>';}?>
                        <input class="wpe-field" type="text" title="(123) 111-1234" name="wpe_phone" id="wpe_phone" <?php if( !$labels ) {?>placeholder="<?php esc_html_e( 'Phone/Cell Phone', 'simple-wp-events' ); echo esc_html($star); ?>" <?php } echo $req_phone ? 'required' : ''; ?>>
                        <small><?php esc_html_e( 'This field is required.', 'simple-wp-events' ); ?></small>
                        <span class="wpe-phone-error-class"><?php esc_html_e( 'Please enter phone in correct format - (123) 111-1234', 'simple-wp-events' ); ?></span>
                    </div>
                    <?php $star = $req_email ? ' *' : ''; ?>
                    <div class="wpe-form-control wpe-field-container wpe-middle-third">
                        <?php if( $labels) { echo'<label for="wpe_email">' . esc_html__( 'Email', 'simple-wp-events' ) . esc_html($star) . '</label>';}?>
                        <input class="wpe-field" type="email" name="wpe_email" id="wpe_email" <?php if( !$labels ) {?>placeholder="<?php esc_html_e( 'Email', 'simple-wp-events' ); echo esc_html($star); ?>" <?php } echo $req_email ? 'required' : ''; ?>>
                        <small><?php esc_html_e( 'This field is required.', 'simple-wp-events' ); ?></small>
                        <span class="wpe-email-error-class"><?php esc_html_e( 'Please enter a valid email address.', 'simple-wp-events' ); ?></span>
                    </div>
                    <?php if ( ! $fax ) { 
                    $star = $req_fax ? ' *' : '';
                    ?>
                    <div class="wpe-form-control wpe-field-container wpe-right-third">
                        <?php if( $labels) { echo'<label for="wpe_fax">' . esc_html__( 'Fax', 'simple-wp-events' ) . esc_html($star) . '</label>';}?>
                        <input class="wpe-field" type="number" name="wpe_fax" id="wpe_fax" <?php if( !$labels ) {?>placeholder="<?php esc_html_e( 'Fax', 'simple-wp-events' ); echo esc_html($star); ?>"<?php } echo $req_fax ? 'required' : ''; ?>>
                        <small><?php esc_html_e( 'This field is required.', 'simple-wp-events' ); ?></small>
                    </div>
                    <?php } ?>
                </div>
                <?php if ( ! $businessName ) { 
                $star = $req_businessName ? ' *' : '';
                ?>
                <div class="wpe-col-full wpe-field">
                    <div class="wpe-form-control wpe-field-container wpe-full-width">
                        <?php if( $labels) { echo'<label for="wpe_business_name">' . esc_html__( 'Business Name', 'simple-wp-events' ) . esc_html($star) . '</label>';}?>
                        <input class="wpe-field" type="text" name="wpe_business_name" id="wpe_business_name" <?php if( !$labels ) {?>placeholder="<?php esc_html_e( 'Business Name', 'simple-wp-events' ); echo esc_html($star); ?>" <?php } echo $req_businessName ? 'required' : ''; ?>>
                        <small><?php esc_html_e( 'This field is required.', 'simple-wp-events' ); ?></small>
                    </div>
                </div>
                <?php } ?>
                <div class="wpe-col-full wpe-field">
                    <?php
                     if ( ! $hearAbout ) {
                    //display dropdown for hear about us
                    wpe_get_dropdown( 'hear_about_us', 'How did you hear about us?', wpe_get_hearaboutus_options() );
                }
                    $option = get_option('wpe_settings');
                    if( isset( $option['privacy_policy'] ) && $option['privacy_policy'] !== '' ) {?>
                    <div class="wpe-form-control wpe-field-container wpe-full-width">
                        <label for="wpe_privacy_policy"><?php esc_html_e( 'Privacy Policy', 'simple-wp-events' ); ?></label>
                        <textarea class="wpe-field" name="wpe_settings[privacy_policy]" id="wpe_privacy_policy" readonly><?php
                            echo esc_textarea( trim(  $option['privacy_policy'] ) );  ?></textarea>
                        <small><?php esc_html_e( 'This field is required.', 'simple-wp-events' ); ?></small>
                    </div>
                    <?php } ?>
                </div>
                <?php
                $consent_box    = isset( $form_options['consent_checkbox'] ) ? $form_options['consent_checkbox'] : esc_html__( 'I have read & consent to the above.*', 'simple-wp-events' );
                $disclaimer_box = isset( $form_options['disclaimer_checkbox'] ) ? $form_options['disclaimer_checkbox'] : esc_html__( 'I have read & understand your website Disclaimer.*', 'simple-wp-events' );
                ?>
                <div class="wpe-col-full wpe-field">
                    <div class="wpe-form-control wpe-field-container wpe-full-width">
                        <input  type="checkbox" name="wpe_consent_box" id="wpe_consent_box" value="I have read &amp; consent to the above." required>
                        <label for="wpe_consent_box"><?php echo wp_kses( $consent_box, wpe_get_allowed_html() ) ?></label>
                        <small><?php esc_html_e( 'This field is required.', 'simple-wp-events' ); ?></small>
                    </div>
                    <div class="wpe-form-control wpe-field-container wpe-full-width">
                        <input  type="checkbox" name="wpe_disclaimer_box" id="wpe_disclaimer_box" value="I have read &amp; understand your website Disclaimer." required>
                        <label for="wpe_disclaimer_box"> <?php echo wp_kses( $disclaimer_box, wpe_get_allowed_html() ) ?></label>
                        <small><?php esc_html_e( 'This field is required.', 'simple-wp-events' ); ?></small>
                    </div>
                    <?php
                    if( $hide_texting_permission ) { 
                    ?>
                    <div class="wpe-form-control wpe-field-container wpe-full-width">
                        <input  type="checkbox" name="wpe_texting_permission" id="wpe_texting_permission" value="1">
                        <label for="wpe_texting_permission"><?php echo wp_kses( do_shortcode( $form_textin_permission ), wpe_get_allowed_html() ); ?></label>
                        <small><?php esc_html_e( 'This field is required.', 'simple-wp-events' ); ?></small>
                    </div>
                    <?php
                    } 
                    ?>
                </div>
                <div class="wpe-col-full wpe-field">
                    <div class="wpe-form-control wpe-field-container wpe-full-width">
	                    <?php
		                    ?>
                            <label for="event-seats"><?php esc_html_e( 'Seats', 'simple-wp-events' ); ?></label>
		                    <?php
                        wpe_get_seats_dropdown();
	                    ?>
                        <small><?php esc_html_e( 'This field is required.', 'simple-wp-events' ); ?></small>
                    </div>
                </div>
                <div style="display: none" class="wpe-full-width wpe-guests-heading"><?php esc_html_e( 'Name(s) of Guest(s) Other Than Yourself', 'simple-wp-events' ) ?></div>
                <div class="guest-info wpe-form-control wpe-field-container wpe-full-width">
                    <div style="display: none" class="wpe-col-2 wpe-field guest-box">
                        <div class="wpe-form-control wpe-field-container wpe-left-half">
                            <?php if( $labels) { echo'<label>' . esc_html__(  'Guest First Name*', 'simple-wp-events' ) . '</label>';}?>
                            <input class="wpe-field wpe-guest-field" type="text" name="wpe_guest_first_name[]" <?php if( !$labels ) {?>placeholder="<?php esc_html_e( 'Guest First Name*', 'simple-wp-events' ); ?>" <?php } ?>>
                            <small><?php esc_html_e( 'Error Message', 'simple-wp-events' ); ?></small>
                        </div>
                        <div class="wpe-form-control wpe-field-container wpe-right-half">
                            <?php if( $labels) { echo'<label>' . esc_html__(  'Guest Last name*', 'simple-wp-events' ) . '</label>';}?>
                            <input class="wpe-field wpe-guest-field" type="text" name="wpe_guest_last_name[]" <?php if( !$labels ) {?>placeholder="<?php esc_html_e( 'Guest Last name*', 'simple-wp-events' ); ?>" <?php } ?>>
                            <small><?php esc_html_e( 'Error Message', 'simple-wp-events' ); ?></small>
                        </div>
                    </div>
                </div>
                <input type="hidden" name="action" value="registration_form">
                <input type="hidden" name="post" value="<?php echo esc_attr(get_the_ID()); ?>">
                <?php wp_nonce_field('wp_event_registration_form','wpe_register_form_nonce');
                $site_key = isset( $captcha_options['reCAPTCHA_site_key'] ) ? $captcha_options['reCAPTCHA_site_key'] : '';
                if( $site_key !== '' ) {
                    ?>
                <div class="form-flex">
                    <div class="wpe-form-control wpe-field-container wpe-full-width">
                        <div class="g-recaptcha" data-expired-callback="CaptchaExpired" data-sitekey="<?php echo esc_attr( $site_key ); ?>" <?php if ( $captcha_options['reCAPTCHA_type'] === 'invisible' ) { echo 'data-size="invisible"'; } ?> ></div>
                        <small class="recaptcha-error"><?php esc_html_e( 'Error Message', 'simple-wp-events' ); ?></small>
                    </div>
                </div>
                        <?php
                    } else {
                        ?>
                        <span class="g-recaptcha"><?php esc_html_e( 'Captcha not found.', 'simple-wp-events' ); ?></span>
                        <?php
                    }
                    ?>
                    <div class="wpe-form-control wpe-field-container wpe-submit-button">
                        <button id="wpe-button" class="button wpe-button"><?php echo esc_html( apply_filters( 'wpe_registration_form_button_text', $form_button ) ); ?></button>
                    </div>
                    <div class="wpe-button-loader"></div>
                </form>
            </div>
        </div>

        <?php
        /**
         * Fires after Registration Form
         *
         * @since 1.0.0
         * @action wpe_after_registration_form
         */
        do_action('wp_event_after_registration_form');
    }
}

add_action('wp_events_registration_form', 'wpe_registration_form');


/**
 * Before Registration Form     Displays HTML or text before registration form
 *
 * @since 1.0.2
*/
if( !function_exists( 'wpe_before_registration_form' ) ) {
	function wpe_before_registration_form() {
		$before_form_message = get_option( 'wpe_forms_settings' );
		if ( isset( $before_form_message['before_registration_form_message'] ) && $before_form_message['before_registration_form_message'] !== '' ) {
			$html = '<div class="before-registration-form"><p>' . $before_form_message['before_registration_form_message'] . '</p></div>';
			echo wp_kses( $html, wpe_get_allowed_html() );
		}
	}
}

add_action( 'wp_event_before_registration_form', 'wpe_before_registration_form' );


/**
 * After Registration Form     Displays HTML or text after registration form
 *
 * @since 1.0.2
 */
if( !function_exists( 'wpe_after_registration_form' ) ) {
	function wpe_after_registration_form() {
		$after_form_message = get_option( 'wpe_forms_settings' );
		if ( isset( $after_form_message['after_registration_form_message'] ) && $after_form_message['after_registration_form_message'] !== '' ) {
			$html = '<div class="after-registration-form"><p>' . $after_form_message['after_registration_form_message'] . '</p></div>';
			echo wp_kses( $html, wpe_get_allowed_html() );
		}
	}
}

add_action( 'wp_event_after_registration_form', 'wpe_after_registration_form' );
